import sys
import re
import base64
import random
import subprocess
import http.client

#USAGE python rai.py [-vlcdir=<dir>][-uagent=<user-agent>] [channel]
#
#channel = RaiUno | RaiDue | RaiTre | RaiQuattro | RaiNews24 | RaiSport+ | RaiStoria | RaiEdu | RaiGulp
#          RaiSatExtra | RaiSatPremium | RaiSatCinema | RaiSatYoyo

vlcdir	= ""
stream	= "http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=983"
agent	= "Mozilla/5.0 (X11; U; Linux x86_64; it; rv:1.9.1.7) Gecko/20100106 Ubuntu/9.10 (karmic) Firefox/3.5.7"

re_url	= "^http://(?P<host>[a-zA-Z0-9]*\.([a-zA-Z0-9]*\.)+[a-zA-Z0-9]*)(?P<path>/[\w\-\+\~\%\#\.\/]*)\?cont\=(?P<chanid>\d*)"
re_date = "^(?P<day>\d*)-(?P<month>\d*)-(?P<year>\d*)\s(?P<hour>\d*):(?P<minutes>\d*):(?P<seconds>\d*)"

urls = {
	"RaiUno":			"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=983",
	"RaiDue":			"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=984",
	"RaiTre":			"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=986",
	"RaiQuattro":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=75708",
	"RaiNews24":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=1",
	"RaiSport+":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=4145",
	"RaiStoria":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=24269",
	"RaiEdu":			"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=24268",
	"RaiGulp":			"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=4119",
	"RaiSatExtra":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=72382",
	"RaiSatPremium":	"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=72383",
	"RaiSatCinema":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=72381",
	"RaiSatYoyo":		"http://mediapolis.rai.it/relinker/relinkerServlet.htm?cont=72384",
}

def encode1(token):
	rnd = random.randint(0,30)
	
	encoded = ""
	for ch in token:
		encoded += chr(ord(ch)^rnd)
	return encoded+";"+str(rnd)

def encode2(token, key="uotyawehtgnikcehc"):
	i = 0
	j = 0
	encoded = ""
	for ch in token:
		encoded += chr(ord(token[i]) ^ ord(key[j]))
		i += 1
		j = (j+1)%17
	return encoded
	
def encode3(token):
	return base64.encodebytes(str.encode(token)).decode()
	
for arg in sys.argv[1:]:
	if( arg.startswith("-") ):
		match_parm = re.match("^-(\w*)=(.*)", arg)
		if type(match_parm).__name__ == "NoneType":
			print("WARNING: "+arg+" is not a valid parms")
			continue
			
		if( match_parm.groups()[0] == "vlcdir" ):
			vlcdir = match_parm.groups()[1]
		elif match_parm.groups()[0] == "uagent":
			agent = match_parm.groups()[1]
		else:
			print("WARNING: unknow argument ("+match_parm.groups()[0]+")")
	else:
		try:
			stream = urls[arg]
		except:
			stream = urls["RaiUno"]
		break

match_url = re.match(re_url, stream).groupdict()
host = match_url["host"] 
path = match_url["path"]
chan = match_url["chanid"]

date_connection = http.client.HTTPConnection("videowall.rai.it")
date_connection.putrequest("GET", "/cgi-bin/date")
date_connection.putheader("User-Agent", agent)
date_connection.endheaders()
date_response = date_connection.getresponse().read()
date_connection.close();
date = bytes.decode(date_response[:len(date_response)-1])

match_date = re.match(re_date, date).groupdict()
day		= match_date["day"]
month	= match_date["month"]
year	= match_date["year"]
hour	= match_date["hour"]
minutes	= match_date["minutes"]
seconds	= match_date["seconds"]

rnd1 = str(random.randint(0, 1234))
rnd2 = str(random.randint(0, 1234))
token = year+";"+chan+";"+day+"-"+month+"-"+rnd1+"-"+hour+"-"+minutes+"-"+seconds+"-"+rnd2

ttAuth = encode3(encode2(encode1(token)))
print(ttAuth)

asx_connection = http.client.HTTPConnection(host)
asx_connection.putrequest("POST", path+"?cont="+chan)
asx_connection.putheader("User-Agent", agent)
asx_connection.putheader("Connection", "keep-alive")
asx_connection.putheader("Keep-Alive", "300")
asx_connection.putheader("viaurl", "www.rai.tv")
asx_connection.putheader("ttAuth", ttAuth)
asx_connection.putheader("Content-Length" "0")
asx_connection.putheader("Content-Type" "application/x-www-form-urlencoded")
asx_connection.endheaders()
asx_response = asx_connection.getresponse().read()
asx_connection.close()
asx = bytes.decode(asx_response)
asx = re.compile("\n").sub(" ", asx)

mms = re.match("^(.*)(?P<mms>mms://.*)\"", asx).groupdict()["mms"]

subprocess.call([vlcdir+"vlc", "--http-user-agent=\""+agent+"\"", mms])
